/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iDate vec4(0.0,0.0,0.0,iGlobalTime)

/////////////////////////////////////////////////////////////////////////////////

// For a 2D function, I use the z component of a vector as the output value, and 
// the x and y components as the slope (derivative) of the function on those axes. 
// This function preserves an accurate slope when multiplying function outputs.
vec3 multiplyWithSlope( vec3 a, vec3 b )
{
	return vec3( a.xy * b.z + b.xy * a.z, a.z * b.z );
}

vec3 ripple( vec2 v )
{
	// time is a sawtooth wave from 0 to 1 every 2 seconds:
	float time = mod( iGlobalTime / 2.0, 1.0 );
	
	float radiusSqared = 2.0 * 2.0 * time;
	
	float lengthSquared = dot( v, v );
	if ( lengthSquared > radiusSqared ) return vec3(0.0);
	
	float frequency = 8.0;
	float phase = (lengthSquared - radiusSqared) * frequency;
	vec3 result = vec3( cos( phase ) * frequency * v * 2.0, sin( phase ) );
	
	// fade out towards the rim:
	vec3 ratio = -vec3( v * 2.0, lengthSquared - radiusSqared ) / radiusSqared;
	ratio = multiplyWithSlope( ratio, ratio );
	result = multiplyWithSlope( result, ratio );
	
	// fade out completely at end
	result *= 1.0 - time;
	
	return result * 0.5;
}

void main()
{
	vec2 v = gl_FragCoord.xy / iResolution.xx;
	v -= vec2(0.5,0.3); // roughly centered
	v *= 10.0; // zoom out
	vec3 result = ripple( v );
	// use red and blue color channels to show slope, and green for height:
	gl_FragColor.rbg = vec3 ( 0.5 - result.xy * 0.5, result.z + 0.5 );
   gl_FragColor.a = 1.0;
}
